<?php

namespace App\Controllers;

use App\Models\Notification_Model;
use App\Models\User_Model;

class Notification extends BaseController
{
    protected $notificationModel;
    protected $userModel;
    protected $request;

    public function __construct()
    {
        $this->notificationModel = new Notification_Model();
        $this->userModel = new User_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
        return view('notification');
    }

    public function getAll()
    {
        $u_id = session()->get('uid');
        $data = $this->notificationModel->where('n_to', $u_id)->findAll();
        for($i = 0; $i < count($data); $i++){
            $message = $data[$i]['message'];
            $divide = explode(' ',$message);
            $last_element = array_pop($divide);
            $udata = $this->userModel->where('uid',$last_element)->first();
            $uname = $udata['uname'];
            $joindata = implode(' ', $divide);
            $data[$i]['message_data'] = $joindata.' '.$uname;
        }
        return json_encode($data);
    }
}
