$(document).ready(function(){
    getStockData();
});
function getStockData(){
    var base_url = $('#base_url').val();
    var editUrl = base_url+'fly-request/edit';
    var viewUrl = base_url+'stock/view-stock-request';
    if($('.dataflystock').length > 0) {
    var table = $('.dataflystock').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "searching": true,
            "paging": true,
            "pageLength": 500, 
            "lengthMenu": [5, 10, 25, 50, 100, 200],  
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": "pi-stock/getPiStockRequest", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [     
        { "data": "s_id" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<a href='`+viewUrl+`/${row.s_id}'>
                            <u>${row.title}</u>  
                          </a>`;
          }
        },
       { "data": "generated_by" },
         { "data": "created" },
        
        { "data": "flycondition" },
        { "data": "pi_email" },
        { "data": "requestedflystatus" },
        // {
        //   "data": null, 
        //   "render": function (data, type, row) {
        //        if(row.f_status == 1){
        //             return `<div class='edit-delete-action'>
        //                   <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+editUrl+`/${row.s_id}'>
        //                       <i data-feather='edit' class='feather-edit'></i>
        //                   </a>
        //                   <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteFlyRequest(${row.s_id})' href='javascript:void(0);'>
        //                       <i data-feather='trash-2' class='feather-trash-2'></i>
        //                   </a>
        //               </div>`;
        //        } else {
        //             return `<div class='edit-delete-action'>
        //                   <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+editUrl+`/${row.s_id}'>
        //                       <i data-feather='edit' class='feather-edit'></i>
        //                   </a>
        //                   <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteFlyRequest(${row.s_id})' href='javascript:void(0);'>
        //                       <i data-feather='trash-2' class='feather-trash-2'></i>
        //                   </a>
        //                   <select class="select" name="status" id="updateStatus" onclick="updateStatus(${row.s_id})">
        //                     <option>Status</option>
        //                     <option value="1">Active</option>
        //                     <option value="0">In-active</option>
        //                   </select>
        //               </div>`;
        //        }
        //   },
        //   "createdCell": function (td, cellData, rowData, row, col) {
        //       $(td).addClass('action-table-data');
        //   }
        // }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
        $('#center_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[3] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#flycondition_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[5] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#availability_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[6] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#date_filter').on('change', function() {
            var order_date = $(this).val(); 
            $.ajax({
                type: "POST",
                url: base_url+"order/orderDate",
                data: {order_date: order_date},
                dataType: 'json',
                success: function(data) { 
                    var selectedValue = data;
                    table.search('').draw();
                    if (selectedValue) {
                        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                            return data[4] === selectedValue; 
                        });
                        table.draw();
                    } else {
                       $.fn.dataTable.ext.search.pop();
                        table.draw();
                    }
                },
                error: function(xhr, status, error) {
                    $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                }
            });
        });
    }
}



$("#fly_bulk_upload_form").submit(function(event) {
    event.preventDefault(); 

    var form = $(this);
    var actionUrl = form.attr('action');
    var formData = new FormData(form[0]); 

    $.ajax({
        type: "POST",
        url: actionUrl,
        data: formData,
        contentType: false, 
        processData: false, 
        success: function(data) { 
            $('#stockupload_save_success').removeClass('d-none');
            $('#stockupload_save_error').addClass('d-none');
        },
        error: function(xhr, status, error) {
            $('#stockupload_save_success').addClass('d-none');
            $('#stockupload_save_error').removeClass('d-none');
        }
    });
});