$(document).ready(function(){
    getStockData();
});
function getStockData(){
    var base_url = $('#base_url').val();
    var editUrl = base_url+'fly-request/edit';
    var viewUrl = base_url+'fly-request/view';
    if($('.dataflystock').length > 0) {
    var table = $('.dataflystock').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "searching": true,
            "paging": true,
            "pageLength": 100, 
            "lengthMenu": [5, 10, 25, 50, 100, 200],  
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": base_url+"fly-request/get", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [     
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<label class="checkboxs">
                            <input type="checkbox" id="${row.f_id}" class="selected-stock-row">
                            <span class="checkmarks"></span>
                        </label>`;
            }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<a href='`+viewUrl+`/${row.f_id}'>
                            <u>${row.f_id}</u>  
                          </a>`;
          }
        },
        { "data": "f_stock_name" },
        { "data": "center" },     
        { "data": "created" },
         { "data": "flycondition" },
         { "data": "availability" },
        { "data": "requester_email" },
       {
          "data": null, 
          "render": function (data, type, row) {
              if(row.f_status == 1){
                return `Active`;
              } else {
                return `In-active`;
              }  
          }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
               if(row.f_status == 1){
                    return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.f_id}' href='`+editUrl+`/${row.f_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.f_id}' onclick='deleteFlyRequest(${row.f_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
               } else {
                    return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.f_id}' href='`+editUrl+`/${row.f_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.f_id}' onclick='deleteFlyRequest(${row.f_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                          <select class="select" name="status" id="updateStatus" onclick="updateStatus(${row.f_id})">
                            <option>Status</option>
                            <option value="1">Active</option>
                            <option value="0">In-active</option>
                          </select>
                      </div>`;
               }
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
        $('#center_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[3] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#flycondition_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[5] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#availability_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[6] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#date_filter').on('change', function() {
            var order_date = $(this).val(); 
            $.ajax({
                type: "POST",
                url: base_url+"order/orderDate",
                data: {order_date: order_date},
                dataType: 'json',
                success: function(data) { 
                    var selectedValue = data;
                    table.search('').draw();
                    if (selectedValue) {
                        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                            return data[4] === selectedValue; 
                        });
                        table.draw();
                    } else {
                       $.fn.dataTable.ext.search.pop();
                        table.draw();
                    }
                },
                error: function(xhr, status, error) {
                    $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                }
            });
        });
    }
}

function deleteFlyRequest(f_id){
    var base_url = $('#base_url').val();
    var f_id = f_id;
    Swal.fire({
    title: "Are you sure you want to delete this fly request?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: base_url+"fly-request/delete", 
            data: {f_id:f_id},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Fly request has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                var table = $('.dataflystock').DataTable();
                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}

$("#fly_request_form").submit(function(e) {
    e.preventDefault(); 

    var f_stock_name = $('#f_stock_name').val();
    var f_genotype = $('#f_genotype').val();
    var f_stock_center = $('#f_stock_center').val(); 
    var f_gene_affected = $('#f_gene_affected').val();
    var f_pi_id = $('#f_pi_id').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (f_stock_name.trim() === '') {
        $('#f_stock_name').addClass('is-invalid');
        $('#f_stock_name_error').removeClass('d-none');
        isValid = false;
    }

    if (f_genotype.trim() === '') {
        $('#f_genotype').addClass('is-invalid');
        $('#f_genotype_error').removeClass('d-none');
        isValid = false;
    }

    if (f_stock_center == 0) {
        $('#f_stock_center').addClass('is-invalid');
        $('#f_stock_center_error').removeClass('d-none');
        isValid = false;
    }

    if (f_gene_affected.trim() === '') {
        $('#f_gene_affected').addClass('is-invalid');
        $('#f_gene_affected_error').removeClass('d-none');
        isValid = false;
    }

    if (f_pi_id == 0) {
        $('#f_pi_id').addClass('is-invalid');
        $('#f_pi_id_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stock_save_error').addClass('d-none');
                $('#stock_save_success').removeClass('d-none');
                setTimeout(function(){     
                    $('#fly_request_form')[0].reset();
                    $('#f_pi_id').val(0).trigger('change');
                    $('#f_stock_center').val(0).trigger('change');
                    $('#f_fly_condition').val(0).trigger('change');
                    $('#stock_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_save_error').removeClass('d-none');
        $('#stock_save_success').addClass('d-none');
    }
});

$("#f_pi_id").change(function() {
    var dataMail = $('select#f_pi_id option:selected').data('mail');
    $('#pi_email').val(dataMail);
});

function updateStatus(f_id){
    var f_id = f_id;
    var status = $('#updateStatus').val();
    var base_url = $('#base_url').val();
    var actionUrl = base_url+'fly-request/update';
    if(status == 1 || status == 0){
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: {f_id:f_id,f_status:status},
            success: function(data) { 
                Swal.fire({
                            icon: "success",
                            title: "Status updated successfully!",
                            text: "Fly request status has been updated.",
                            confirmButtonClass: "btn btn-success",
                          });
                var table = $('.dataflystock').DataTable();
                table.ajax.reload(); 
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    }
}

$("#fly_request_edit_form").submit(function(e) {
    e.preventDefault(); 

    var f_stock_name = $('#f_stock_name').val();
    var f_genotype = $('#f_genotype').val();
    var f_stock_center = $('#f_stock_center').val();
    var f_gene_affected = $('#f_gene_affected').val();
    var f_pi_id = $('#f_pi_id').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (f_stock_name.trim() === '') {
        $('#f_stock_name').addClass('is-invalid');
        $('#f_stock_name_error').removeClass('d-none');
        isValid = false;
    }

    if (f_genotype.trim() === '') {
        $('#f_genotype').addClass('is-invalid');
        $('#f_genotype_error').removeClass('d-none');
        isValid = false;
    }

    if (f_stock_center == 0) {
        $('#f_stock_center').addClass('is-invalid');
        $('#f_stock_center_error').removeClass('d-none');
        isValid = false;
    }

    if (f_gene_affected.trim() === '') {
        $('#f_gene_affected').addClass('is-invalid');
        $('#f_gene_affected_error').removeClass('d-none');
        isValid = false;
    }

    if (f_pi_id == 0) {
        $('#f_pi_id').addClass('is-invalid');
        $('#f_pi_id_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stock_save_error').addClass('d-none');
                $('#stock_save_success').removeClass('d-none');
                setTimeout(function(){     
                    $('#fly_request_edit_form')[0].reset();
                    $('#f_pi_id').val(0);
                    $('#f_stock_center').val(0);
                    $('#stock_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_save_error').removeClass('d-none');
        $('#stock_save_success').addClass('d-none');
    }
});

$("#fly_bulk_upload_form").submit(function(event) {
    event.preventDefault(); 

    var form = $(this);
    var actionUrl = form.attr('action');
    var formData = new FormData(form[0]); 

    $.ajax({
        type: "POST",
        url: actionUrl,
        data: formData,
        contentType: false, 
        processData: false, 
        success: function(data) { 
            $('#stockupload_save_success').removeClass('d-none');
            $('#stockupload_save_error').addClass('d-none');
        },
        error: function(xhr, status, error) {
            $('#stockupload_save_success').addClass('d-none');
            $('#stockupload_save_error').removeClass('d-none');
        }
    });
});