$(document).ready(function(){
	getCommunicationData();
});
function getCommunicationData(){
	$.ajax({
            type: "GET",
            url: "communication/get", 
             dataType: 'json',
            success: function(data) {
                if(data != null){
                    $('#n_id').val(data.n_id);
                    if(data.email_not == '1'){ 
                        $('#email_not').prop('checked', true);
                    } else {
                        $('#email_not').prop('checked', false);
                    }
                    if(data.whatsapp_not == '1'){ 
                        $('#whatsapp_not').prop('checked', true);
                    } else {
                        $('#whatsapp_not').prop('checked', false);
                    }
                    if(data.sms_not == '1'){ 
                        $('#sms_not').prop('checked', true);
                    } else {
                        $('#sms_not').prop('checked', false);
                    }
                    $('#summernote').summernote('code',data.message_template); 
                } else {
                    $('#email_not').prop('checked', false);
                    $('#whatsapp_not').prop('checked', false);
                    $('#sms_not').prop('checked', false);
                }                 
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
}

$("#notification_setting_form").submit(function(e) {
    e.preventDefault();  
    var form = $(this);
    var actionUrl = form.attr('action'); 
    var n_id = $('#n_id').val(); 
    var email_not = $('#email_not').is(':checked') ? 1 : 0; 
    var whatsapp_not = $('#whatsapp_not').is(':checked') ? 1 : 0;
    var sms_not = $('#sms_not').is(':checked') ? 1 : 0;
    if($('#summernote').length > 0){
        var message_template = $('#summernote').summernote('code');
    } else {
        var message_template = '';
    } 
    var input = {
                  'n_id': n_id,
                  'email_not': email_not,
                  'whatsapp_not': whatsapp_not,
                  'sms_not': sms_not,
                  'message_template': message_template
                };      
    $.ajax({
        type: "POST",
        url: actionUrl,
        data: input,
        success: function(data) {
            setTimeout(function(){
                $('#notification_save_error').addClass('d-none');
                $('#notification_save_success').removeClass('d-none');
                location.reload();    
            }, 2000);       
        },
        error: function(xhr, status, error) {
            $('#notification_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
    
});