<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Events/News List</h4>
								<h6>Manage Your Events/News</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-event"><i data-feather="plus-circle" class="me-2"></i>Add New Event</a>
						</div>
					</div>


					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								
							</div>							
							<div class="table-responsive">
								<table class="table datanewseventnew">
									<thead>
										<tr>											
											<th>News Title</th>											
											<th>Event Title</th>
											<th>Date</th>											
											<th class="no-sort">Action</th>
										</tr>
									</thead>
									<tbody>
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Add User -->
		<div class="modal fade" id="add-event">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Add Events/News</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="<?=base_url('website/event/save');?>" id="newsevent_form" enctype="multipart/form-data">
									<div class="row">
										<div class="col-lg-12 d-none" id="newsevent_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="newsevent_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form submitted successfully!</center>
											</div>
											<br />
										</div> 										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>News Title</label>
												<input type="text" class="form-control" id="n_title" name="n_title">
												<div class="invalid-feedback d-none" id="n_title_error">Please provide a news title</div>
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>News Content</label>
												<textarea class="form-control" id="n_content" name="n_content"></textarea>
												<div class="invalid-feedback d-none" id="n_content_error">Please provide a news content</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Event Title</label>
												<input type="text" class="form-control" id="e_title" name="e_title">
												<div class="invalid-feedback d-none" id="e_title_error">Please provide a event title</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Event Date</label>
												<input type="date" class="form-control" id="e_date" name="e_date">
												<div class="invalid-feedback d-none" id="e_date_error">Please provide a event date</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Event Description</label>
												<textarea class="form-control" id="e_description" name="e_description"></textarea>
											</div>
										</div>		
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Image Upload</label>
												<input type="file" class="form-control" id="n_image" name="n_image">
											</div>
										</div>							
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Add events/news</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Add User -->

		<!-- Edit User -->
		<div class="modal fade" id="edit-news">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Edit Events/News</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="<?=base_url('website/event/update');?>" id="newsevent_edit_form" enctype="multipart/form-data">
									<div class="row">
										<div class="col-lg-12 d-none" id="newsevent1_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="newsevent1_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form updated successfully!</center>
											</div>
											<br />
										</div> 										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>News Title</label>
												<input type="hidden" id="n_id" name="n_id">
												<input type="text" class="form-control" id="n_title1" name="n_title">
												<div class="invalid-feedback d-none" id="n_title1_error">Please provide a news title</div>
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>News Content</label>
												<textarea class="form-control" id="n_content1" name="n_content"></textarea>
												<div class="invalid-feedback d-none" id="n_content1_error">Please provide a news content</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Event Title</label>
												<input type="text" class="form-control" id="e_title1" name="e_title">
												<div class="invalid-feedback d-none" id="e_title1_error">Please provide a event title</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Event Date</label>
												<input type="date" class="form-control" id="e_date1" name="e_date">
												<div class="invalid-feedback d-none" id="e_date1_error">Please provide a event date</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Event Description</label>
												<textarea class="form-control" id="e_description1" name="e_description"></textarea>
											</div>
										</div>		
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Image Upload</label>
												<p>Existing Image: <span id="n_image2"></span></p>
												<input type="file" class="form-control" id="n_image1" name="n_image">
											</div>
										</div>							
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Update events/news</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Edit User -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>
<?php echo view('layouts/footer.php'); ?>