<?php

namespace App\Models;

use CodeIgniter\Model;

class Stock_Model extends Model
{
    protected $table = 'stock';

    protected $primaryKey = 's_id';

    protected $allowedFields = ['s_id','st_cat_id','ncbs_id','title', 'barcode', 'old_ncbs_id', 'genotype', 'cg_number', 
                                'visible_markers','obtained_by','generated_by','phenotype','publications',
                                'choromosome_affected','fly_base_link','price','fly_condition','availability','sort_order','comment','stock_created_by','s_created_at','s_updated_on','pi_id','is_active','pi_email','requested_fly_status','stock_handled_by','gene_affected'];

    public function saveExcel($data){
        $builder = $this->db->table('stock');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $piData = $data[$i][20];
                if($piData != ''){
                    $piresult = $this->db->table('users')->where('uname',$piData)->get();
                    $pioutput = $piresult->getResult();
                    $pi_id = $pioutput[0]->uid;
                }
                $catData = $data[$i][0];
                if($catData != ''){
                    $catresult = $this->db->table('stockCategory')->where('scat_name',$catData)->get();
                    $catoutput = $catresult->getResult(); 
                    if(count($catoutput)){
                       $st_cat_id = $catoutput[0]->scat_id;
                     }else{
                        return false;
                     }


                    
                }
                $flyData = $data[$i][15];
                if($flyData != ''){
                    $flyresult = $this->db->table('flyCondition')->where('f_status',$flyData)->get();
                    $flyoutput = $flyresult->getResult();
                    $fly_condition = $flyoutput[0]->fid;
                }
                $availData = $data[$i][16];
                if($availData != ''){
                    $availresult = $this->db->table('availability')->where('av_name',$availData)->get();
                    $availoutput = $availresult->getResult();
                    $availability = $availoutput[0]->av_id;
                }

                // $grpData = $data[$i][22];
                // if($grpData != ''){
                //     $grpresult = $this->db->table('groups')->where('gname',$grpData)->get();
                //     $grpoutput = $grpresult->getResult();
                //     $grp_id = $grpoutput[0]->g_id;
                // }

                $builder->insert([
                    'st_cat_id' => $st_cat_id ? $st_cat_id : 0,
                    'ncbs_id' => $data[$i][1] ? $data[$i][1] : '',
                    'title' => $data[$i][2] ? $data[$i][2] : '',
                    'barcode' => $data[$i][3] ? $data[$i][3] : '',
                    'old_ncbs_id' => $data[$i][4] ? $data[$i][4] : '',
                    'genotype' => $data[$i][5] ? $data[$i][5] : '',
                    'cg_number' => $data[$i][6] ? $data[$i][6] : '',
                    'phenotype' => $data[$i][7] ? $data[$i][7] : '',
                    'generated_by' => $data[$i][8] ? $data[$i][8] : '',
                    
                    'visible_markers' => $data[$i][9] ? $data[$i][9] : '',
                    'obtained_by' => $data[$i][10] ? $data[$i][10] : '',
                    
                    
                    
                    'choromosome_affected' => $data[$i][11] ? $data[$i][11] : '',
                    'publications' => $data[$i][12] ? $data[$i][12] : '',
                    'fly_base_link' => $data[$i][13] ? $data[$i][13] : '',
                    'price' => $data[$i][14] ? $data[$i][14] : '',
                    'fly_condition' => $fly_condition ? $fly_condition : 0,
                    'availability' => $availability ? $availability : 0,
                    'sort_order' => $data[$i][17] ? $data[$i][17] : '',
                    'comment' => $data[$i][18] ? $data[$i][18] : '',
                    'stock_created_by' => session()->get('uid') ? session()->get('uid') : 0,
                    'gene_affected' => $data[$i][19] ? $data[$i][19] : '',
                    'pi_id' => isset($pi_id) ? $pi_id : 0,
                    'pi_email' => $data[$i][21] ? $data[$i][21] : ''
                    // 'g_id' => isset($grp_id) ? $grp_id : 0


                ]);
            } 
        }
        return true;
    }

    public function saveStockExcel($data){
        $builder = $this->db->table('stock');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $builder->insert([
                    'st_cat_id' => 4,
                    'title' => $data[$i][1] ? $data[$i][1] : '',
                    'genotype' => $data[$i][2] ? $data[$i][2] : '',
                    'phenotype' => $data[$i][3] ? $data[$i][3] : '',
                    'generated_by' => $data[$i][4] ? $data[$i][4] : '', 
                    'gene_affected' => $data[$i][5] ? $data[$i][5] : '',
                    'pi_email' => $data[$i][6] ? $data[$i][6] : '',
                    'visible_markers' => $data[$i][7] ? $data[$i][7] : '',
                    'obtained_by' => $data[$i][8] ? $data[$i][8] : '',
                    'publications' => $data[$i][9] ? $data[$i][9] : '',
                    'choromosome_affected' => $data[$i][10] ? $data[$i][10] : '',
                    'fly_base_link' => $data[$i][11] ? $data[$i][11] : '',
                    'comment' => $data[$i][12] ? $data[$i][12] : ''
                ]);
            } 
        }
        return true;
    }

    public function updateExcel($data){
        $builder = $this->db->table('stock');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $s_id = $data[$i][0];
                $piData = $data[$i][2];
                if($piData != ''){
                    $piresult = $this->db->table('users')->where('uname',$piData)->get();
                    $pioutput = $piresult->getResult();
                    $pi_id = $pioutput[0]->uid;
                }
                $catData = $data[$i][1];
                if($catData != ''){
                    $catresult = $this->db->table('stockCategory')->where('scat_name',$catData)->get();
                    $catoutput = $catresult->getResult();
                    $st_cat_id = $catoutput[0]->scat_id;
                }
                $flyData = $data[$i][17];
                if($flyData != ''){
                    $flyresult = $this->db->table('flyCondition')->where('f_status',$flyData)->get();
                    $flyoutput = $flyresult->getResult();
                    $fly_condition = $flyoutput[0]->fid;
                }
                $availData = $data[$i][18];
                if($availData != ''){
                    $availresult = $this->db->table('availability')->where('av_name',$availData)->get();
                    $availoutput = $availresult->getResult();
                    $availability = $availoutput[0]->av_id;
                }
                $update = array(
                                'st_cat_id' => $st_cat_id,
                                'pi_id' => isset($pi_id) ? $pi_id : 0,
                                'ncbs_id' => $data[$i][3] ? $data[$i][3] : '',
                                'title' => $data[$i][4] ? $data[$i][4] : '',
                                'barcode' => $data[$i][5] ? $data[$i][5] : '',
                                'old_ncbs_id' => $data[$i][6] ? $data[$i][6] : '',
                                'genotype' => $data[$i][7] ? $data[$i][7] : '',
                                'cg_number' => $data[$i][8] ? $data[$i][8] : '',
                                'phenotype' => $data[$i][9] ? $data[$i][9] : '',
                                'generated_by' => $data[$i][10] ? $data[$i][10] : '',
                                'visible_markers' => $data[$i][11] ? $data[$i][11] : '',  
                                'obtained_by' => $data[$i][12] ? $data[$i][12] : '',
                                'choromosome_affected' => $data[$i][13] ? $data[$i][13] : '',                
                                'publications' => $data[$i][14] ? $data[$i][14] : '',          
                                'fly_base_link' => $data[$i][15] ? $data[$i][15] : '',
                                'price' => $data[$i][16] ? $data[$i][16] : '',
                                'fly_condition' => $fly_condition,
                                'availability' => $availability ? $availability : 0,
                                'sort_order' => $data[$i][19] ? $data[$i][19] : '',
                                'comment' => $data[$i][20] ? $data[$i][20] : '',
                                'gene_affected' => $data[$i][21] ? $data[$i][21] : '',
                   
                                'pi_email' => $data[$i][22] ? $data[$i][22] : ''
                            );
                $builder->update($update, ['s_id' => $s_id]); 
            } 
        }
        return true;
    }

    public function getPiStock($pi_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,flyCondition.f_status as flycondition'); 
        $builder->join('stockTransfer', 'stock.s_id = stockTransfer.st_stock_id','inner');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->where('stockTransfer.st_new_handler', $pi_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getAll($st_cat_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,DATE_FORMAT(stock.s_created_at, "%d %b %Y") as created,stockCategory.scat_name as category,flyCondition.f_status as flycondition,availability.av_name as availability,users.uname,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('availability', 'stock.availability = availability.av_id','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->where('stock.st_cat_id',$st_cat_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getBulkAll($s_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.s_id,stockCategory.scat_name as category,users.uname,ncbs_id,title,barcode,old_ncbs_id,
            genotype,cg_number,phenotype,generated_by,visible_markers,obtained_by,choromosome_affected,publications,fly_base_link,
            price,flyCondition.f_status as flycondition,availability.av_name as availability,sort_order,comment,gene_affected,pi_email,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('availability', 'stock.availability = availability.av_id','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->whereIn('stock.s_id',$s_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getBulkEditAll($s_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,DATE_FORMAT(stock.s_created_at, "%d %b %Y") as created,stockCategory.scat_name as category,flyCondition.f_status as flycondition,users.uname,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->whereIn('stock.s_id',$s_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByCategory()
    {
        $builder = $this->db->table('stock');
        $builder->select('stockCategory.scat_id as id,stockCategory.scat_name as category,count(stock.s_id) as count'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->groupBy('stock.st_cat_id');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

     public function stockByCommonCategory()
    {
        $builder = $this->db->table('stockCategory');
        $builder->select('stockCategory.scat_id as id,stockCategory.scat_name as category,count(stock.s_id) as count'); 
        $builder->join('stock', 'stock.st_cat_id = stockCategory.scat_id', 'left');
        $builder->where('stockCategory.parent_scat_id',1);
        $builder->groupBy('stockCategory.scat_id');
        $builder->groupBy('stockCategory.scat_name');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByCommonFlyWise()
    {
       $builder = $this->db->table('flyCondition'); // Start with flyCondition to ensure all are included

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count'); // COUNT(stock.s_id) handles NULLs to give 0

        // LEFT JOIN 'stock' to 'flyCondition'.
        // Crucially, the condition here will ensure we only consider stock records
        // that are linked to a stockCategory whose parent_scat_id is 1.
        $builder->join(
            'stock',
            'stock.fly_condition = flyCondition.fid',
            'left'
        );

        // Now, LEFT JOIN 'stockCategory' to 'stock'.
        // This is where we apply the parent category filter.
        // We use 'left' here too, so if a stock record exists but its category doesn't match
        // the parent_scat_id, the 'stock' record itself will still be included in the join from flyCondition,
        // but stockCategory.parent_scat_id will be NULL, which we then handle in the WHERE clause.
        $builder->join(
            'stockCategory',
            'stock.st_cat_id = stockCategory.scat_id',
            'left'
        );

        // The WHERE clause is crucial here. We need to count stock that matches the
        // parent category AND ensure fly conditions with no matching stock are still included.
        // This is achieved by checking if the stockCategory.parent_scat_id is 1 OR if stock.s_id is NULL.
        // This handles cases where a flyCondition has NO stock matching the criteria.
        $builder->where(
            'stockCategory.parent_scat_id', 1
        );
        // Important: The line below is critical if you want to include fly conditions
        // that have *no stock at all* (and thus no matching category).
        // However, if the current WHERE clause (stockCategory.parent_scat_id = 1) is applied,
        // it will filter out rows where stockCategory.parent_scat_id is NULL.

        // To get ALL fly conditions, and then apply the filter only to the COUNTING:
        // The most robust way is to push the category filtering into the JOIN for 'stock'.

        $builder = $this->db->table('flyCondition'); // Start with flyCondition again

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count');

        // LEFT JOIN stock, and within that join, include the condition that links to
        // the parent category. This requires linking to stockCategory inside this complex JOIN.
        // This gets a bit tricky to express in a single CodeIgniter join clause directly.

        // Let's use a subquery approach for clarity and robustness when involving multiple levels of LEFT JOINs
        // with specific filters that should allow for zero counts.

        // Subquery to get the relevant stock IDs based on parent_scat_id = 1
        $subQueryStock = $this->db->table('stock');
        $subQueryStock->select('stock.s_id, stock.fly_condition'); // Select relevant stock data
        $subQueryStock->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id'); // INNER JOIN is fine here
        $subQueryStock->where('stockCategory.parent_scat_id', 1); // Filter by parent category ID
        $filteredStockSql = $subQueryStock->getCompiledSelect(); // Get the SQL string of the subquery

        // Main query
        $builder = $this->db->table('flyCondition');
        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(filtered_stock.s_id) AS count'); // Count from the filtered stock

        // LEFT JOIN flyCondition with the results of the subquery
        // This ensures all flyConditions are included, and only relevant stock is counted.
        $builder->join("($filteredStockSql) AS filtered_stock", 'flyCondition.fid = filtered_stock.fly_condition', 'left');

        $builder->groupBy('flyCondition.fid');
        $builder->groupBy('flyCondition.f_status');

        $query = $builder->get();
        $output = $query->getResult();
                return $output; 
    }


     public function getPiCollectionPiWise(){
        $builder = $this->db->table('users');
        $builder->select('users.uname, users.uid AS id');

        // Use a raw SQL expression to conditionally count stocks for parent_scat_id = 2
        // This ensures that even if a user has no matching stocks, they are included with a count of 0.
        $builder->select('COUNT(CASE WHEN stockCategory.parent_scat_id = 2 THEN stock.s_id ELSE NULL END) as count', false);
        // The 'false' parameter prevents CodeIgniter from trying to protect the raw SQL expression with backticks.

        $builder->join('stock', 'stock.pi_id = users.uid', 'left');
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id', 'left');

        $builder->where('users.is_active', 1); // Only active users
        $builder->where('users.u_roll_id', 1); // Only active users
        // No top-level WHERE clause on stockCategory.parent_scat_id here,
        // as the condition is now handled within the COUNT() function.

        $builder->groupBy('users.uid');
        $builder->groupBy('users.uname');

        $query = $builder->get();
        $output = $query->getResult();
        return $output;
    }

     public function stockByPiCollectionFlyWise()
    {
       $builder = $this->db->table('flyCondition'); // Start with flyCondition to ensure all are included

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count'); // COUNT(stock.s_id) handles NULLs to give 0

        // LEFT JOIN 'stock' to 'flyCondition'.
        // Crucially, the condition here will ensure we only consider stock records
        // that are linked to a stockCategory whose parent_scat_id is 1.
        $builder->join(
            'stock',
            'stock.fly_condition = flyCondition.fid',
            'left'
        );

        // Now, LEFT JOIN 'stockCategory' to 'stock'.
        // This is where we apply the parent category filter.
        // We use 'left' here too, so if a stock record exists but its category doesn't match
        // the parent_scat_id, the 'stock' record itself will still be included in the join from flyCondition,
        // but stockCategory.parent_scat_id will be NULL, which we then handle in the WHERE clause.
        $builder->join(
            'stockCategory',
            'stock.st_cat_id = stockCategory.scat_id',
            'left'
        );

        // The WHERE clause is crucial here. We need to count stock that matches the
        // parent category AND ensure fly conditions with no matching stock are still included.
        // This is achieved by checking if the stockCategory.parent_scat_id is 1 OR if stock.s_id is NULL.
        // This handles cases where a flyCondition has NO stock matching the criteria.
        $builder->where(
            'stockCategory.parent_scat_id', 1
        );
        // Important: The line below is critical if you want to include fly conditions
        // that have *no stock at all* (and thus no matching category).
        // However, if the current WHERE clause (stockCategory.parent_scat_id = 1) is applied,
        // it will filter out rows where stockCategory.parent_scat_id is NULL.

        // To get ALL fly conditions, and then apply the filter only to the COUNTING:
        // The most robust way is to push the category filtering into the JOIN for 'stock'.

        $builder = $this->db->table('flyCondition'); // Start with flyCondition again

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count');

        // LEFT JOIN stock, and within that join, include the condition that links to
        // the parent category. This requires linking to stockCategory inside this complex JOIN.
        // This gets a bit tricky to express in a single CodeIgniter join clause directly.

        // Let's use a subquery approach for clarity and robustness when involving multiple levels of LEFT JOINs
        // with specific filters that should allow for zero counts.

        // Subquery to get the relevant stock IDs based on parent_scat_id = 1
        $subQueryStock = $this->db->table('stock');
        $subQueryStock->select('stock.s_id, stock.fly_condition'); // Select relevant stock data
        $subQueryStock->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id'); // INNER JOIN is fine here
        $subQueryStock->where('stockCategory.parent_scat_id', 2); // Filter by parent category ID
        $filteredStockSql = $subQueryStock->getCompiledSelect(); // Get the SQL string of the subquery

        // Main query
        $builder = $this->db->table('flyCondition');
        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(filtered_stock.s_id) AS count'); // Count from the filtered stock

        // LEFT JOIN flyCondition with the results of the subquery
        // This ensures all flyConditions are included, and only relevant stock is counted.
        $builder->join("($filteredStockSql) AS filtered_stock", 'flyCondition.fid = filtered_stock.fly_condition', 'left');

        $builder->groupBy('flyCondition.fid');
        $builder->groupBy('flyCondition.f_status');

        $query = $builder->get();
        $output = $query->getResult();
                return $output; 
    }



    public function stockByDate()
    {
        $builder = $this->db->table('stock');
        $builder->select('DATE_FORMAT(stock.s_created_at, "%d %b %Y") as date,count(stock.s_id) as dcount'); 
        $builder->groupBy('DATE(stock.s_created_at)');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByAvl()
    {
        $builder = $this->db->table('stock');
        $builder->select('availability,count(stock.s_id) as acount'); 
        $builder->groupBy('availability');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByGroup()
    {
        $builder = $this->db->table('stock');
        $builder->select('gname,count(stock.s_id) as gcount'); 
        $builder->join('groups', 'stock.g_id = groups.g_id','left');
        $builder->groupBy('stock.g_id');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getStockDetails($sid)
    {
        $builder = $this->db->table('stock');
        $builder->select('stock.*,groups.gname'); 
        $builder->join('groups', 'stock.g_id = groups.g_id','left');
        $builder->where('stock.s_id',$sid);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }


     public function getAllParentCatStock($st_cat_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,DATE_FORMAT(stock.s_created_at, "%d %b %Y") as created,stockCategory.scat_name as category,flyCondition.f_status as flycondition,availability.av_name as availability,users.uname,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('availability', 'stock.availability = availability.av_id','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->where('stockCategory.parent_scat_id',$st_cat_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }


    public function getAllParentCatStockUserId($st_cat_id,$uids){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,DATE_FORMAT(stock.s_created_at, "%d %b %Y") as created,stockCategory.scat_name as category,flyCondition.f_status as flycondition,availability.av_name as availability,requested_flystatus.fs_name as requestedflystatus,users.uname,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('requested_flystatus', 'stock.requested_fly_status = requested_flystatus.fs_id','left');
        $builder->join('availability', 'stock.availability = availability.av_id','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->where('stockCategory.parent_scat_id',$st_cat_id);
        $builder->whereIn('stock.stock_created_by',$uids);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getStockByIdRange($start, $end)
{
    $builder = $this->db->table('stock');
    $builder->select('*');

    // Simple string comparison
    $builder->where("ncbs_id >=", $start);
    $builder->where("ncbs_id <=", $end);
    $builder->where("availability !=", 'Stock Not Available');
    $builder->where("availability !=", 'Dead');
     $builder->where("availability !=", '3');


    // Optional: order by string
    $builder->orderBy("ncbs_id", "ASC");

    $query = $builder->get();
    return $query->getResult();
}







}