<?php

namespace App\Models;

use CodeIgniter\Model;

class Notification_Model extends Model
{
    protected $table = 'notification';

    protected $primaryKey = 'n_id';

    protected $allowedFields = ['message','n_from','n_to','n_created_at','n_updated_on','n_is_read'];

    public function getlast()
    {
        $u_id = session()->get('uid');
        $data = $this->db->table('notification')  
                        ->where('n_to', $u_id)
                        ->where('n_is_read', '0')
                        ->limit(5)
                        ->orderBy('n_id', 'desc')
                        ->get()
                        ->getResult();
        foreach ($data as $i => $notification) {
            $message = $notification->message; 
            $divide = explode(' ', $message); 
            $last_element = array_pop($divide); 

            $udata = $this->db->table('users')->where('uid', $last_element)->get()->getResult();
            
            if ($udata) {
                $uname = $udata[0]->uname; 
                $joindata = implode(' ', $divide); 
                $notification->message_data = $joindata . ' ' . $uname; 
            } else {
                $notification->message_data = $message;
            }

            $created_at = $notification->n_created_at; 
            $current_timestamp = time();  
            $created_timestamp = strtotime($created_at); 
            $time_difference =  $created_timestamp - $current_timestamp;
            $hours = floor($time_difference / 3600);
            $minutes = floor(($time_difference % 3600) / 60);
            $seconds = $time_difference % 60;
            
            $h = ($hours > 0) ? $hours.' hrs, ' : '';
            $m = ($minutes > 0) ? $minutes.' mins, ' : '';
            $s = ($seconds > 0) ? $seconds.' secs' : '';
            $notification->timediff = $h.$m.$s;

        }
        return json_encode($data);
    }

}