<?php

namespace App\Models;

use CodeIgniter\Model;

class Dashboard_Model extends Model
{

    public function getTotalData()
    {
        $data = array();
        $u_roll_id = session()->get('u_roll_id');
        if($u_roll_id == 6){
            $data['uCount'] = $this->db->table('users')->where('u_roll_id !=', 6)->countAllResults();
            $data['gCount'] = $this->db->table('groups')->countAllResults();
            $data['oCount'] = $this->db->table('orders')->countAllResults();
            $data['sCount'] = $this->db->table('stock')->countAllResults();
        } else {
            $g_id = $this->getUserGroups();
            $data['uCount'] = $this->db->table('userGroups')->whereIn('g_id',$g_id)->groupBy('u_id')->countAllResults();
            $data['gCount'] = count($g_id);
            $data['oCount'] = $this->db->table('orders')->countAllResults();
            $data['sCount'] = $this->db->table('stock')->countAllResults();
        }
        return $data;
    }

    public function getUserData()
    {
        $g_id = $this->getUserGroups();
        $builder = $this->db->table('users'); 
        $builder->select('users.uid,users.uname,users.uemail,roles.role,DATE_FORMAT(users.u_created_at, "%d %b %Y") as date'); 
        $builder->join('roles', 'users.u_roll_id = roles.r_id', 'left'); 
        $builder->join('userGroups','users.uid = userGroups.u_id','left');
        $builder->groupBy('users.uid');
        $builder->orderBy('users.uid','desc');
        $builder->where('users.u_roll_id !=',6);
        $builder->whereIn('userGroups.g_id',$g_id);
        $builder->limit(5);
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getGroupData()
    {
        $builder = $this->db->table('groups'); 
        $builder->select('gname,users.uname as pi,gname,count(userGroups.g_id) as members');
        $builder->join('users','groups.pi_id = users.uid','left');
        $builder->join('userGroups','groups.g_id = userGroups.g_id','left');
        $builder->orderBy('groups.g_id','desc');
        $builder->groupBy('groups.g_id','desc');
        $builder->limit(5);
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getOrderData()
    {
        $builder = $this->db->table('orders'); 
        $builder->orderBy('o_id','desc');
        $builder->limit(5);
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getPiTotalData($uid)
    {
        $data = array();
        $data['gCount'] = $this->db->table('userGroups')->where('u_id',$uid)->countAllResults();
        $data['oCount'] = $this->db->table('orders')->where('u_id',$uid)->countAllResults();
        $data['sCount'] = $this->db->table('stockTransfer')->where('st_new_handler',$uid)->countAllResults();
        return $data;
    }

    public function getFlyCondition()
    {
        $builder = $this->db->table('flyCondition'); 
        $builder->select('f_status');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getFlyConditionPercentageold()
    {
        $tscount = $this->db->table('stock')->countAllResults();
        $builder = $this->db->table('stock'); 
        $builder->join(
            'stockCategory',
            'stock.st_cat_id = stockCategory.scat_id',
            'left'
        );
         $builder->join(
            'flyCondition',
            'flyCondition.fid = stock.fly_condition',
            'left'
        );

       
        // $builder->select('ROUND(((count(s_id)/100)*'.$tscount.')* 100) as data'); 
         $builder->select('count(s_id) as data'); 
         $builder->groupBy('flyCondition.fid');
        $builder->groupBy('flyCondition.f_status');

        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getFlyConditionPercentage($parent_scat_id)
    {
        $builder = $this->db->table('flyCondition'); // Start with flyCondition to ensure all are included

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count'); // COUNT(stock.s_id) handles NULLs to give 0

        // LEFT JOIN 'stock' to 'flyCondition'.
        // Crucially, the condition here will ensure we only consider stock records
        // that are linked to a stockCategory whose parent_scat_id is 1.
        $builder->join(
            'stock',
            'stock.fly_condition = flyCondition.fid',
            'left'
        );

        // Now, LEFT JOIN 'stockCategory' to 'stock'.
        // This is where we apply the parent category filter.
        // We use 'left' here too, so if a stock record exists but its category doesn't match
        // the parent_scat_id, the 'stock' record itself will still be included in the join from flyCondition,
        // but stockCategory.parent_scat_id will be NULL, which we then handle in the WHERE clause.
        $builder->join(
            'stockCategory',
            'stock.st_cat_id = stockCategory.scat_id',
            'left'
        );

        // The WHERE clause is crucial here. We need to count stock that matches the
        // parent category AND ensure fly conditions with no matching stock are still included.
        // This is achieved by checking if the stockCategory.parent_scat_id is 1 OR if stock.s_id is NULL.
        // This handles cases where a flyCondition has NO stock matching the criteria.
        $builder->where(
            'stockCategory.parent_scat_id', $parent_scat_id
        );
        // Important: The line below is critical if you want to include fly conditions
        // that have *no stock at all* (and thus no matching category).
        // However, if the current WHERE clause (stockCategory.parent_scat_id = 1) is applied,
        // it will filter out rows where stockCategory.parent_scat_id is NULL.

        // To get ALL fly conditions, and then apply the filter only to the COUNTING:
        // The most robust way is to push the category filtering into the JOIN for 'stock'.

        $builder = $this->db->table('flyCondition'); // Start with flyCondition again

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count');

        // LEFT JOIN stock, and within that join, include the condition that links to
        // the parent category. This requires linking to stockCategory inside this complex JOIN.
        // This gets a bit tricky to express in a single CodeIgniter join clause directly.

        // Let's use a subquery approach for clarity and robustness when involving multiple levels of LEFT JOINs
        // with specific filters that should allow for zero counts.

        // Subquery to get the relevant stock IDs based on parent_scat_id = 1
        $subQueryStock = $this->db->table('stock');
        $subQueryStock->select('stock.s_id, stock.fly_condition'); // Select relevant stock data
        $subQueryStock->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id'); // INNER JOIN is fine here
        $subQueryStock->where('stockCategory.parent_scat_id', $parent_scat_id); // Filter by parent category ID
        $filteredStockSql = $subQueryStock->getCompiledSelect(); // Get the SQL string of the subquery

        // Main query
        $builder = $this->db->table('flyCondition');
        $builder->select('count(s_id) as data');  // Count from the filtered stock

        // LEFT JOIN flyCondition with the results of the subquery
        // This ensures all flyConditions are included, and only relevant stock is counted.
        $builder->join("($filteredStockSql) AS filtered_stock", 'flyCondition.fid = filtered_stock.fly_condition', 'left');

        $builder->groupBy('flyCondition.fid');
        $builder->groupBy('flyCondition.f_status');

        $query = $builder->get();
        $output = $query->getResult();
                return $output; 
    }

    public function getUserGroups()
    {
        $u_id = session()->get('uid');
        $group = $this->db->table('groups')
                  ->select('g_id')
                  ->where('g_created_by', $u_id)
                  ->get()
                  ->getResult();
        for($i = 0; $i < count($group); $i++){
           $g_id[$i] = $group[$i]->g_id; 
        }
        return $g_id;
    }

    public function getFlyConditionPercentagePi($parent_scat_id,$uids)
    {
        $builder = $this->db->table('flyCondition'); // Start with flyCondition to ensure all are included

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count'); // COUNT(stock.s_id) handles NULLs to give 0

        // LEFT JOIN 'stock' to 'flyCondition'.
        // Crucially, the condition here will ensure we only consider stock records
        // that are linked to a stockCategory whose parent_scat_id is 1.
        $builder->join(
            'stock',
            'stock.fly_condition = flyCondition.fid',
            'left'
        );

        // Now, LEFT JOIN 'stockCategory' to 'stock'.
        // This is where we apply the parent category filter.
        // We use 'left' here too, so if a stock record exists but its category doesn't match
        // the parent_scat_id, the 'stock' record itself will still be included in the join from flyCondition,
        // but stockCategory.parent_scat_id will be NULL, which we then handle in the WHERE clause.
        $builder->join(
            'stockCategory',
            'stock.st_cat_id = stockCategory.scat_id',
            'left'
        );

        // The WHERE clause is crucial here. We need to count stock that matches the
        // parent category AND ensure fly conditions with no matching stock are still included.
        // This is achieved by checking if the stockCategory.parent_scat_id is 1 OR if stock.s_id is NULL.
        // This handles cases where a flyCondition has NO stock matching the criteria.
        $builder->where(
            'stockCategory.parent_scat_id', $parent_scat_id
        );
        // Important: The line below is critical if you want to include fly conditions
        // that have *no stock at all* (and thus no matching category).
        // However, if the current WHERE clause (stockCategory.parent_scat_id = 1) is applied,
        // it will filter out rows where stockCategory.parent_scat_id is NULL.

        // To get ALL fly conditions, and then apply the filter only to the COUNTING:
        // The most robust way is to push the category filtering into the JOIN for 'stock'.

        $builder = $this->db->table('flyCondition'); // Start with flyCondition again

        $builder->select('flyCondition.fid AS id');
        $builder->select('flyCondition.f_status AS flycondition');
        $builder->select('COUNT(stock.s_id) AS count');

        // LEFT JOIN stock, and within that join, include the condition that links to
        // the parent category. This requires linking to stockCategory inside this complex JOIN.
        // This gets a bit tricky to express in a single CodeIgniter join clause directly.

        // Let's use a subquery approach for clarity and robustness when involving multiple levels of LEFT JOINs
        // with specific filters that should allow for zero counts.

        // Subquery to get the relevant stock IDs based on parent_scat_id = 1
        $subQueryStock = $this->db->table('stock');
        $subQueryStock->select('stock.s_id, stock.fly_condition'); // Select relevant stock data
        $subQueryStock->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id'); // INNER JOIN is fine here
        $subQueryStock->where('stockCategory.parent_scat_id', $parent_scat_id);
        $subQueryStock->whereIn('stock.stock_created_by',$uids);
        $filteredStockSql = $subQueryStock->getCompiledSelect(); // Get the SQL string of the subquery

        // Main query
        $builder = $this->db->table('flyCondition');
        $builder->select('count(s_id) as data');  // Count from the filtered stock

        // LEFT JOIN flyCondition with the results of the subquery
        // This ensures all flyConditions are included, and only relevant stock is counted.
        $builder->join("($filteredStockSql) AS filtered_stock", 'flyCondition.fid = filtered_stock.fly_condition', 'left');

        $builder->groupBy('flyCondition.fid');
        $builder->groupBy('flyCondition.f_status');

        $query = $builder->get();
        $output = $query->getResult();
                return $output; 
    }

}