$(document).ready(function(){
	getStockCategoryData();
});
function getStockCategoryData(){
	if($('.datastockCategory').length > 0) {
	var table = $('.datastockCategory').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',  
			"ordering": true,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		 "ajax": {
      "url": "stock-category/get", 
      "type": "GET", 
      "dataSrc": "" 
  		},
    	"columns": [
        { "data": "scat_name" },
        { "data": "scat_centers" },
        { "data": "f_status" },
        { "data": "status" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.scat_id}' onclick='editStockCategory(${row.scat_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.scat_id}' onclick='deleteStockCategory(${row.scat_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
		$('#role_filter').on('change', function() {
            table.search($(this).val()).draw();
        });
        $('#group_filter').on('change', function() {
            table.search($(this).val()).draw();
        });
	}
}

function editStockCategory(scat_id){	
	$.ajax({
            type: "GET",
            url: "stock-category/getById/"+scat_id,
            dataType: 'json',
            success: function(data) {
        		$('#scat_id').val(data.scat_id);
                $('#scat_name1').val(data.scat_name);
        		$('#scat_centers1').val(data.scat_centers);
        		$('#scat_fly_conditions1').val(data.scat_fly_conditions).trigger('change');
			    $('#scat_ord_status1').val(data.scat_ord_status).trigger('change');
                $('#stock_type_id1').val(data.stock_type_id).trigger('change');
                $('#edit-stock-category').modal('show');
            },
            error: function(xhr, status, error) {
                $('#stockcategory1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#stock_category_edit_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

    var scat_name = $('#scat_name1').val();
    var scat_centers = $('#scat_centers1').val();
    var scat_fly_conditions = $('#scat_fly_conditions1').val();
    var scat_ord_status = $('#scat_ord_status1').val();
    
    var isValid = true; 

    // Clear previous validation states
    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (scat_name == '') {
        $('#scat_name1').addClass('is-invalid');
        $('#scat_name_error1').removeClass('d-none');
        isValid = false;
    }

    if (scat_centers == '') {
        $('#scat_centers1').addClass('is-invalid');
        $('#scat_centers_error1').removeClass('d-none');
        isValid = false;
    } 

    if (scat_fly_conditions == '') {
        $('#scat_fly_conditions1').addClass('is-invalid');
        $('#scat_fly_conditions_error1').removeClass('d-none');
        isValid = false;
    }

    if (scat_ord_status == '') {
        $('#scat_ord_status1').addClass('is-invalid');
        $('#scat_ord_status_error1').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stockcategory1_save_error').addClass('d-none');
                $('#stockcategory1_save_success').removeClass('d-none');
                var table = $('.datastockCategory').DataTable();
                table.ajax.reload();
                setTimeout(function(){
                    $('#edit-stock-category').modal('hide');
                    $('#stock_category_edit_form')[0].reset();
                    $('#scat_ord_status1').val(0).trigger('change');
                    $('#scat_fly_conditions1').val(0).trigger('change');
                    $('#stockcategory1_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stockcategory1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stockcategory1_save_error').removeClass('d-none');
        $('#stockcategory1_save_success').addClass('d-none');
    }
});

$("#stock_category_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

    var scat_name = $('#scat_name').val();
    var scat_centers = $('#scat_centers').val();
    var scat_fly_conditions = $('#scat_fly_conditions').val();
    var scat_ord_status = $('#scat_ord_status').val();
    
    var isValid = true; 

    // Clear previous validation states
    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (scat_name == '') {
        $('#scat_name').addClass('is-invalid');
        $('#scat_name_error').removeClass('d-none');
        isValid = false;
    }

    if (scat_centers == '') {
        $('#scat_centers').addClass('is-invalid');
        $('#scat_centers_error').removeClass('d-none');
        isValid = false;
    } 

    if (scat_fly_conditions == '') {
        $('#scat_fly_conditions').addClass('is-invalid');
        $('#scat_fly_conditions_error').removeClass('d-none');
        isValid = false;
    }

    if (scat_ord_status == '') {
        $('#scat_ord_status').addClass('is-invalid');
        $('#scat_ord_status_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stock_category_save_error').addClass('d-none');
                $('#stock_category_save_success').removeClass('d-none');
                var table = $('.datastockCategory').DataTable();
                table.ajax.reload();
                setTimeout(function(){
                    $('#add-stock-category').modal('hide');
                    $('#stock_category_form')[0].reset();
                    $('#scat_ord_status').val(0).trigger('change');
                    $('#scat_fly_conditions').val(0).trigger('change');
                    $('#stock_type_id').val(0).trigger('change');
                    $('#stock_category_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stock_category_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_category_save_error').removeClass('d-none');
        $('#stock_category_save_success').addClass('d-none');
    }
});
function deleteStockCategory(scat_id){
	var scat_id = scat_id;
	Swal.fire({
    title: "Are you sure you want to delete this stock category?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
    	$.ajax({
            type: "POST",
            url: "stock-category/delete", 
            data: {scat_id:scat_id},
            success: function(data) {
                Swal.fire({
					        icon: "success",
					        title: "Deleted!",
					        text: "Stock category details has been deleted.",
					        confirmButtonClass: "btn btn-success",
					      });
				var table = $('.datastockCategory').DataTable();
				table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}