<?php

namespace App\Models;

use CodeIgniter\Model;

class Group_Model extends Model
{
    protected $table = 'groups';

    protected $primaryKey = 'g_id';

    protected $allowedFields = ['gname','pi_id','g_created_at','g_updated_at','g_created_by'];

    public function getAll($g_id = null){
        $builder = $this->db->table('groups'); 
        $builder->select('groups.g_id,groups.gname,groups.pi_id,GROUP_CONCAT(users.uname) as members,GROUP_CONCAT(users.uid) as uid'); 
        $builder->join('userGroups', 'groups.g_id = userGroups.g_id', 'left');
        $builder->join('users', 'userGroups.u_id = users.uid','left');
        if($g_id != null){
            $builder->where('groups.g_id',$g_id);
        }
        $builder->groupBy('groups.g_id');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getPiGroupData($uid){
        $gid = array();
        $builder = $this->db->table('userGroups'); 
        $builder->select('groups.g_id'); 
        $builder->join('groups', 'userGroups.g_id = groups.g_id', 'inner');
        $builder->where('userGroups.u_id',$uid);
        $query = $builder->get(); 
        $data = $query->getResult();
        for($i = 0; $i < count($data); $i++){
            $gid[$i] = $data[$i]->g_id;
        }
        if(empty($gid)){
            $output = [];
        } else {
            $builder = $this->db->table('userGroups');
            $builder->select('groups.g_id,groups.gname,GROUP_CONCAT(users.uname) as members'); 
            $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
            $builder->join('users', 'userGroups.u_id = users.uid','left');
            $builder->whereIn('userGroups.g_id',$gid);
            $builder->groupBy('userGroups.g_id');
            $query = $builder->get(); 
            $output = $query->getResult();
        }
        return $output; 
    }

}