<?php

namespace App\Models;

use CodeIgniter\Model;

class Role_Model extends Model
{
    protected $table = 'roles';

    protected $primaryKey = 'r_id';

    protected $allowedFields = ['role'];

    public function getJoinedData($approve)
    {
        $u_roll_id = session()->get('u_roll_id');
        if($u_roll_id == 6){
            $builder = $this->db->table('users'); 
            $builder->select('users.uid,users.uname,users.uemail,users.upassword,roles.role,GROUP_CONCAT(groups.gname) as gname,users.is_active'); 
            $builder->join('roles', 'users.u_roll_id = roles.r_id', 'left'); 
            $builder->join('userGroups', 'users.uid = userGroups.u_id', 'left');
            $builder->join('groups', 'userGroups.g_id = groups.g_id', 'left');
            $builder->groupBy('users.uid');
            $builder->orderBy('users.uid', 'DESC');
            $builder->where('users.is_approve',$approve);
            $builder->where('users.u_roll_id !=',6);
            $query = $builder->get(); 
            return $query->getResult(); 
        } else {
            $g_id = $this->getUserGroups();
            if(empty($g_id)){
                return [];
            } else {
                $builder = $this->db->table('users'); 
                $builder->select('users.uid,users.uname,users.uemail,users.upassword,roles.role,GROUP_CONCAT(groups.gname) as gname,users.is_active'); 
                $builder->join('roles', 'users.u_roll_id = roles.r_id', 'left'); 
                $builder->join('userGroups', 'users.uid = userGroups.u_id', 'left');
                $builder->join('groups', 'userGroups.g_id = groups.g_id', 'left');
                $builder->groupBy('users.uid');
                 $builder->orderBy('users.uid', 'DESC');
                $builder->where('users.is_approve',$approve);
                $builder->where('users.u_roll_id !=',6);
                $builder->whereIn('userGroups.g_id',$g_id);
                $query = $builder->get(); 
                return $query->getResult(); 
            }
        }
    }

    public function getUserGroups()
    {
        $u_id = session()->get('uid');
        $u_roll_id = session()->get('u_roll_id');
        if($u_roll_id == 6){
            $group = $this->db->table('groups')
                  ->select('g_id')
                  ->get()
                  ->getResult();
        } else {
            $group = $this->db->table('groups')
                  ->select('g_id')
                  ->where('g_created_by', $u_id)
                  ->get()
                  ->getResult();
        }
        if(empty($group)){
            $g_id = [];
        } else {
            for($i = 0; $i < count($group); $i++){
               $g_id[$i] = $group[$i]->g_id; 
            }
        }
        return $g_id;
    }

}