$(document).ready(function(){
	getStockData();
    getCartData();
});
function getStockData(){
	if($('.datapistock').length > 0) {
    var st_cat_id = $('#st_cat_id').val();
	var table = $('.datapistock').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',  
			"ordering": true,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		  "ajax": {
          "url": "getPiStock/"+st_cat_id, 
          "type": "GET", 
          "dataSrc": "" 
      		},
        	"columns": [
                { "data": "s_id" },
                { "data": "title" },
                { "data": "genotype" },
                { "data": "availability"},
                { "data": "flycondition"},
                {
                  "data": null, 
                  "render": function (data, type, row) {
                      return `<div class="edit-delete-action">`+
                                    `<a class="me-2 p-2" onclick='getStockDetails(${row.s_id})'>`+
                                        `<i data-feather='eye' class='feather-eye'></i>`+
                                    `</a>`+
                                    `<div class="page-btn">`+
                                    `<a href="#" class="btn btn-secondary" onclick='addToCart(${row.s_id})'> Add to Cart <i data-feather="arrow-right" class="me-2"></i></a>`+
                                    `</div>`+
                                `</div>`;
                  },
                  "createdCell": function (td, cellData, rowData, row, col) {
                      $(td).addClass('action-table-data');
                  }
                }
            ],
    		initComplete: (settings, json)=>{
    			$('.dataTables_filter').appendTo('#tableSearch');
    			$('.dataTables_filter').appendTo('.search-input');

    		},	
    	});
        $('#genotype_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[2] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#availability_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[3] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
	}
}

function getStockDetails(s_id){
    var s_id = s_id; 
    var base_url = $('#base_url').val();
    $.ajax({
        type: "GET",
        url: base_url+'pi-stock/getStockDetails/'+s_id,
        dataType: 'json',
        success: function(data) { 
            $('#fly_stock_name').html(data[0].title);
            $('#genotype').html(data[0].genotype);
            $('#phenotype').html(data[0].phenotype);
            $('#generated_by').html(data[0].generated_by);
            $('#gene_affected').html(data[0].gene_affected);
            $('#pi_email').html(data[0].pi_email);
            $('#visible_markers').html(data[0].visible_markers);
            $('#obtained_by').html(data[0].obtained_by);
            $('#publications').html(data[0].publications);
            $('#choromosome_affected').html(data[0].choromosome_affected);
            $('#fly_base_link').html(data[0].fly_base_link);
            $('#group_name').html(data[0].gname);
            $('#comment').html(data[0].comment);
            $('#view-pi-stock').modal('show');
        },
        error: function(xhr, status, error) {
            $('#user_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
}

function addToCart(s_id){
    var uid = $('#uid').val(); 
    var base_url = $('#base_url').val();
    $.ajax({
        type: "POST",
        dataType: 'json',
        url: base_url+'pi-save-cart',
        data: { s_id: s_id, u_id: uid },
        success: function(data) {
            
             if(data == 'duplicate'){
                    
                    setTimeout(function(){
                        $('#error_text').text('Cart with similar Stock Id already exists');
                         $('#cart_save_error').removeClass('d-none');
                    }, 1000);

                    setTimeout(function(){
                          $('#error_text').text('Form should not be Empty!');
                          $('#cart_save_error').addClass('d-none');
                    }, 7000);
                  
                    
                }else if(data == 'success'){

                $('#cart_save_success').removeClass('d-none');
                    setTimeout(function(){
                       $('#cart_save_success').addClass('d-none');
                       var table = $('.datapistock').DataTable();
                        table.ajax.reload();     
                    }, 2000);   
                }


                },
        error: function(xhr, status, error) {
            $('#cart_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
}

function getCartData(){
    if($('.datapicart').length > 0) {
    var uid = $('#uid').val();
    var base_url = $('#base_url').val();
    var table = $('.datapicart').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
          "ajax": {
          "url": base_url+"pi-cart/getPiCart/"+uid, 
          "type": "GET", 
          "dataSrc": "" 
            },
            "columns": [
                { "data": "s_id" },
                { "data": "title" },
                { "data": "availability"},
                
                  {
                  "data": null, 
                  "render": function (data, type, row) {
                      return `<div class="edit-delete-action">`+
                                    `<a class="me-2 p-2" onclick='deleteCart(${row.c_id})'>`+
                                        `<i data-feather='eye' class='feather-trash-2'></i>`+
                                    `</a>`+
                                    `<div class="page-btn">`+
                                    `<a href="#" class="btn btn-secondary" onclick='placeOrder(${row.c_id})'> Place Order <i data-feather="arrow-right" class="me-2"></i></a>`+
                                    `</div>`+
                                `</div>`;
                  },
                  "createdCell": function (td, cellData, rowData, row, col) {
                      $(td).addClass('action-table-data');
                  }
                }
            ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
    }
}

function placeOrder(c_id){
    var u_id = $('#uid').val(); 
    var base_url = $('#base_url').val();
    // var cartStock = $('.cartStock').map(function() {
    //     var id = this.id;
    //     var id1 = id.split('-');
    //     return id1[2];
    // }).get();
    
    $.ajax({
        type: "POST",
        url: base_url+'pi-save-order',
        dataType: 'json',
        data: { 'cart_id': c_id, 'u_id': u_id },
        success: function(data) { 
              
             
             if(data == 'duplicate'){
                    
                    setTimeout(function(){
                        $('#error_text_1').text('Order with similar Stock Id already exists');
                         $('#cart_save_error').removeClass('d-none');
                    }, 1000);

                    setTimeout(function(){
                          $('#error_text_1').text('Order Not Placed!');
                          $('#cart_save_error').addClass('d-none');
                    }, 7000);
                  
                    
                }else if(data == 'success'){

                $('#cart_save_success').removeClass('d-none');
                setTimeout(function(){
                   $('#cart_save_success').addClass('d-none');
                   var table = $('.datapicart').DataTable();
                    table.ajax.reload();     
                }, 2000); 


                }
        },
        error: function(xhr, status, error) {
            $('#cart_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
}