<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Group List</h4>
								<h6>Manage Your Groups</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-groups"><i data-feather="plus-circle" class="me-2"></i>Add New Group</a>
						</div>
					</div>


					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							
							<div class="table-responsive">
								<table class="table datagroupnew">
									<thead>
										<tr>											
											<th>Group Name</th>											
											<th>PI</th>
											<th>Members</th>											
											<th class="no-sort">Action</th>
										</tr>
									</thead>
									<tbody>
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Add User -->
		<div class="modal fade" id="add-groups">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Add Group</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form id="group_form" action="<?=base_url('group/save');?>">
									<div class="row">
										<div class="col-lg-12 d-none" id="group_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="group_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form submitted successfully!</center>
											</div>
											<br />
										</div> 									
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Group Name</label>
												<input type="text" name="gname" id="gname" class="form-control">
												<div class="invalid-feedback d-none" id="gname_error">Please provide a group name</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Choose PI</label>
												<select class="select" name="pi_id" id="pi_id">
													<option value="">Choose</option>
													<?php foreach ($pi as $pi): ?>
													<option value="<?= $pi['uid'] ?>"><?= $pi['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="pi_id_error">Please choose a PI</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Choose Members</label>
												<select class="select u_ids" name="u_ids[]" id="u_ids" multiple="multiple">
													<option>Choose</option>
													<option value="">Choose</option>
													<?php foreach ($members as $member): ?>
													<option value="<?= $member['uid'] ?>"><?= $member['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="uids_error">Please choose Member</div>
											</div>
										</div>																		
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Create</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Add User -->

		<!-- Edit User -->
		<div class="modal fade" id="edit-groups">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Edit Group</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="<?=base_url('group/update');?>" id="group_edit_form">
									<div class="row">
										<div class="col-lg-12 d-none" id="group1_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="group1_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form updated successfully!</center>
											</div>
											<br />
										</div> 											
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Group Name</label>
												<input type="hidden" id="edit_gid" name="edit_gid">
												<input type="text" name="gname1" id="gname1" class="form-control">
												<div class="invalid-feedback d-none" id="gname1_error">Please provide a group name</div>
											</div>
										</div>									
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Choose PI</label>
												<select class="select" name="pi_id1" id="pi_id1">
													<option value="">Choose</option>
													<?php foreach ($pi1 as $pi): ?>
													<option value="<?= $pi['uid'] ?>"><?= $pi['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="pi_id1_error">Please choose a PI</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Choose Members</label>
												<select class="select u_ids" name="u_ids1[]" id="u_ids1" multiple="multiple">
													<option value="">Choose</option>
													<?php foreach ($members as $member): ?>
													<option value="<?= $member['uid'] ?>"><?= $member['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="uids1_error">Please choose Member</div>
											</div>
										</div>										
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Submit</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Edit User -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>