<?php

namespace App\Controllers;

use PhpOffice\PhpSpreadsheet\IOFactory;
use Picqer\Barcode\BarcodeGeneratorPNG;


use App\Models\Stock_Model;
use App\Models\StockTransfer_Model;
use App\Models\User_Model;
use App\Models\Barcode_Model;
use App\Models\StockBarcode_Model;
use App\Models\Cart_Model;
use App\Models\StockCategory_Model;
use App\Models\StockComment_Model;
use App\Models\StockUpdateRecord_Model;
use App\Models\StockTypes_Model;
use App\Models\Flycondition_Model;
use App\Models\FlyStatus_Model;
use App\Models\Group_Model;
use App\Models\Availability_Model;
use App\Models\Activities_Model;
use App\Models\Notification_Model;
use App\Models\Order_Model;
use App\Models\Security_Model;

class Stock extends BaseController
{
    protected $stockModel;
    protected $userModel;
    protected $stockTransferModel;
    protected $barcodeModel;
    protected $stockbarcodeModel;
    protected $cartModel;
    protected $stockCategoryModel;
    protected $StockCommentModel;
    protected $stockUpdateRecordModel;
    protected $flyConditionModel;
    protected $flyStatusModel;
    protected $groupModel;
    protected $availabilityModel;
    protected $activitiesModel;
    protected $notificationModel;
    protected $orderModel;
    protected $securityModel;
    protected $request;

    public function __construct()
    {
        $this->stockModel = new Stock_Model();
        $this->userModel = new User_Model();
        $this->stockTransferModel = new StockTransfer_Model();
        $this->request = service('request');
        $this->barcodeModel = new Barcode_Model();
        $this->stockbarcodeModel = new StockBarcode_Model();
        $this->cartModel = new Cart_Model();
        $this->stockCategoryModel = new StockCategory_Model();
        $this->StockCommentModel = new StockComment_Model();
        $this->stockUpdateRecordModel = new StockUpdateRecord_Model();
        $this->flyConditionModel = new Flycondition_Model();
        $this->flyStatusModel = new FlyStatus_Model();
        $this->groupModel = new Group_Model();
        $this->availabilityModel = new Availability_Model();
        $this->activitiesModel = new Activities_Model();
        $this->notificationModel = new Notification_Model();
        $this->orderModel = new Order_Model();
        $this->securityModel = new Security_Model();
    }

    public function index($st_cat_id)
    {
		$data['category'] = $this->stockCategoryModel->findAll();
        $data['user'] = $this->userModel->where('u_roll_id','1')->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['availability'] = $this->availabilityModel->findAll();
        $data['users'] = $this->userModel->where('u_roll_id', '5')->where('is_active', '1')->where('is_approve', '1')->findAll();
        $data['st_cat_id'] = $st_cat_id;
        return view('stocks',$data);
    }

    public function getAll($st_cat_id)
    {

        $data = $this->stockModel->getAllParentCatStock($st_cat_id);
        return json_encode($data);
    }

    public function addStock($st_cat_id): string
    {
        $data['category'] = $this->stockCategoryModel->where('parent_scat_id',$st_cat_id)->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['availability'] = $this->availabilityModel->findAll();
        $data['pis'] = $this->userModel->where('u_roll_id','1')->findAll();
        return view('add-stock',$data);
    }

    public function addStockRequestPage(): string
    {
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['flyStatus'] = $this->flyStatusModel->findAll();
        return view('add-stock-request',$data);
    }

    public function save()
    {
        $stock = $this->request->getPost();
        $this->securityModel->sanitize_form_array($stock);

        $ncbs_id = $this->request->getPost('ncbs_id');
        $data = $this->stockModel->where('ncbs_id',$ncbs_id)->findAll();
        $total = count($data);
        if($total > 0){
            return json_encode('duplicate');
        }
        
        if($this->stockModel->save($stock)){
              $s_id = $this->stockModel->insertID();
              $stockcomment = array();
              $stockcomment['s_id'] = $s_id;
              if($this->request->getPost('comment') != ''){
                $stockcomment['sc_comment'] = $this->request->getPost('comment');
              $this->StockCommentModel->save($stockcomment);
              }
              
            return json_encode('success');

        } else {
            return false;
        }
    }

    public function delete()
    {
        $activity = array();
        $s_id = $this->request->getPost('s_id');
        $this->securityModel->sanitize_input($s_id);
        if($this->stockModel->delete($s_id)){
            $activity['uid'] = session()->get('uid');
            $activity['a_data'] = $s_id.' - stock deleted';
            $this->activitiesModel->save($activity);
            return true;
        } else {
            return false;
        }  
    }
    public function editStock($s_id): string
    {
        $data['stock'] = $this->stockModel->where('s_id', $s_id)->first();
        $data['category'] = $this->stockCategoryModel->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['availability'] = $this->availabilityModel->findAll();
        $data['pis'] = $this->userModel->where('u_roll_id','1')->findAll();
        return view('edit-stock',$data);
    }

     public function editStockRequest($s_id): string
    {
        $data['stock'] = $this->stockModel->where('s_id', $s_id)->first();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['flyStatus'] = $this->flyStatusModel->findAll();
        return view('edit-stock-request',$data);
    }


    public function viewStock($s_id): string
    {
        $data['stock'] = $this->stockModel->where('s_id', $s_id)->first();
        $data['category'] = $this->stockCategoryModel->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['availability'] = $this->availabilityModel->findAll();
        $data['comment'] = $this->StockCommentModel->where('s_id', $s_id)->findAll();
        $data['record'] = $this->stockUpdateRecordModel->getAllStockRecords($s_id);
        $data['pis'] = $this->userModel->where('u_roll_id','1')->findAll();
        return view('view-stock',$data);
    }

    public function viewStockRequest($s_id): string
    {
        $data['stock'] = $this->stockModel->where('s_id', $s_id)->first();
       
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['flyStatus'] = $this->flyStatusModel->findAll();
        $data['comment'] = $this->StockCommentModel->where('s_id', $s_id)->findAll();
        $data['record'] = $this->stockUpdateRecordModel->getAllStockRecords($s_id);
    
        return view('view-stock-request',$data);
    }

    public function update()
    {
        $s_id = $this->request->getPost('s_id');
        $stock = array();
        $stock['st_cat_id'] = $this->request->getPost('st_cat_id');
        $stock['ncbs_id'] = $this->request->getPost('ncbs_id');
        $stock['title'] = $this->request->getPost('title');
        $stock['barcode'] = $this->request->getPost('barcode');
        $stock['old_ncbs_id'] = $this->request->getPost('old_ncbs_id');
        $stock['genotype'] = $this->request->getPost('genotype');
        $stock['cg_number'] = $this->request->getPost('cg_number');
        $stock['visible_markers'] = $this->request->getPost('visible_markers');
        $stock['obtained_by'] = $this->request->getPost('obtained_by');
        $stock['generated_by'] = $this->request->getPost('generated_by');
        $stock['phenotype'] = $this->request->getPost('phenotype');
        $stock['publications'] = $this->request->getPost('publications');
        $stock['choromosome_affected'] = $this->request->getPost('choromosome_affected');
        $stock['fly_base_link'] = $this->request->getPost('fly_base_link');
        $stock['price'] = $this->request->getPost('price');
        $stock['fly_condition'] = $this->request->getPost('fly_condition');
        $stock['availability'] = $this->request->getPost('availability');
        $stock['sort_order'] = $this->request->getPost('sort_order');
        $stock['comment'] = $this->request->getPost('comment');
        $stock['pi_id'] = $this->request->getPost('pi_id');
        $stock['pi_email'] = $this->request->getPost('pi_email');
        $stock['gene_affected'] = $this->request->getPost('gene_affected');
        $stock['requested_fly_status'] = $this->request->getPost('requested_fly_status');
        $stock['is_active'] = $this->request->getPost('is_active');


        $this->securityModel->sanitize_form_array($stock);
        if($this->stockModel->update($s_id,$stock)){
            $notification['message'] = $s_id.' - stock updated';
            $notification['n_from'] = session()->get('uid');
            $this->notificationModel->save($notification);
              $stockcomment = array();
              $stockcomment['s_id'] = $s_id;
              $stockcomment['sc_comment'] = $this->request->getPost('comment');
              $this->StockCommentModel->save($stockcomment);

              $stockrecord['s_id'] = $s_id;
              $stockrecord['uid'] = session()->get('uid');
              $this->stockUpdateRecordModel->save($stockrecord);

            return true;
        } else {
            return false;
        }
    }

    public function acceptStock()
    {
        $s_id = $this->request->getPost('s_id');
        $this->securityModel->sanitize_input($s_id);
        $stock = array();
        $stock['is_active'] = $this->request->getPost('is_active');
        $this->securityModel->sanitize_form_array($stock);
        if($this->stockModel->update($s_id,$stock)){
            $notification['message'] = $s_id.' - stock accepted';
            $notification['n_from'] = session()->get('uid');
            $this->notificationModel->save($notification);
            return true;
        } else {
            return false;
        }
    }

    public function bulkUpload(): string
    {
        return view('bulk-upload');
    }

    public function stockBulkUpload(): string
    {
        return view('stock-bulk-upload');
    }

    public function bulkUploadSave()
    {
        $file = $this->request->getFile('upload');

        if ($file->isValid() && !$file->hasMoved()) {

            $file->move(WRITEPATH . 'uploads/');
            
            $filePath = WRITEPATH . 'uploads/' . $file->getName();

            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($filePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray();
            
            if($this->stockModel->saveExcel($sheetData)){
                return json_encode('success');
            } else{
                return json_encode('error');
            }     
        }
    }

    public function stockBulkUploadSave()
    {
        $file = $this->request->getFile('upload');

        if ($file->isValid() && !$file->hasMoved()) {
            
            $filePath = WRITEPATH . 'uploads/' . $file->getName();
            $file->move(WRITEPATH . 'uploads/');

            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($filePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray();
            
            if($this->stockModel->saveStockExcel($sheetData)){
                return true;
            } else{
                return false;
            }     
        }
    }

    public function barcodeList(): string
    {
        return view('barcodeList');
    }

    public function deleteBarcode()
    {
        $b_id = $this->request->getPost('b_id');
        $this->securityModel->sanitize_input($b_id);
        if($this->barcodeModel->delete($b_id)){
            $this->stockbarcodeModel->where('barcode_id', $b_id)->delete();
            return true;
        } else {
            return false;
        }  
    }

    public function getBarcodeList()
    {
        $data = $this->barcodeModel->findAll();
        return json_encode($data);
    }

    public function barcodeGeneration(): string
    {
        return view('barcode-generation');
    }

    public function saveBarcode(){
        $barcode = array();
        $code = $this->request->getPost('code');
        $barcode['barcode'] = implode(',',$code);
        $this->securityModel->sanitize_form_array($barcode);
        $this->barcodeModel->save($barcode);
        $b_id = $this->barcodeModel->insertID(); 
        if($b_id){
            for($i = 0; $i < count($code); $i++){
                $stockBarcode = array();
                $stockBarcode['barcode_id'] = $b_id;
                $stockBarcode['s_id'] = $code[$i];
                $this->stockbarcodeModel->save($stockBarcode);
            }
            return true;
        } else {
            return false;
        }
    }

    public function searchStock(){
        $search = $this->request->getPost('search');
        $this->securityModel->sanitize_input($search);
        $data = $this->stockModel->where('fly_stock_name', $search)->first(); 
        return json_encode($data);  
    }

    public function handlingRecords(): string
    {
        return view('handling-records');
    }

    public function trackingRecords(): string
    {
        $data['users'] = $this->userModel->where('u_roll_id', '5')->findAll();
        $data['stocks'] = $this->stockModel->findAll();
        return view('tracking-records',$data);
    }

    public function getTrackingRecords()
    {
        $data = $this->stockTransferModel->getJoinedData();
        return json_encode($data);
    }

    public function saveTrackingRecords()
    {
        $stockTransfer = $this->request->getPost();
        $this->securityModel->sanitize_form_array($stockTransfer);
        if($this->stockTransferModel->save($stockTransfer)){
            return true;
        } else {
            return false;
        }
    }

    public function getStockTransferId($st_id)
    {
        $data = $this->stockTransferModel->where('st_id', $st_id)->first();
        return json_encode($data);
    }

    public function transferDate()
    {
       $transfer_date = $this->request->getPost('transfer_date'); 
       $formattedDate = date('d M Y', strtotime($transfer_date));
       return json_encode($formattedDate);
    }

    public function pistock($st_cat_id){

        $data['st_cat_id'] = $st_cat_id;
        return view('pi-stocks',$data);
    }

    public function myStock(){
        return view('my-stocks');
    }

    public function piStockRequest(){
        return view('pi-stock-request');
    }

    public function getPiStock($st_cat_id){
        // $data = array();
        // $stockTransfer = $this->stockTransferModel->where('st_new_handler',$pi_id)->first();
        // if(!empty($stockTransfer)){
        //     $st_stock_id = $stockTransfer['st_stock_id'];
        //     $cart = $this->cartModel->where('s_id',$st_stock_id)->first();
        //     if(empty($cart)){
        //         $data = $this->stockModel->getPiStock($pi_id);
        //     } else {
        //         $data = array();
        //     }   
        // } 

        // for pi stock 

        if($st_cat_id == 1){

            $data = $this->stockModel->getAllParentCatStock($st_cat_id);

        }elseif($st_cat_id ==3){

               $uids = array();
               if (session()->get('u_roll_id') == 1) { 
                   $pi_uid = session()->get('uid');
                   $data = $this->groupModel->getPiGroupData($pi_uid);
                if(!empty($data)){
                     $uids =  explode(',' ,$data[0]->uid);
                }else{
                     $uids[] = $pi_uid; 
                }
                   $data = $this->stockModel->getAllParentCatStockUserId($st_cat_id,$uids);
            
               }elseif(session()->get('u_roll_id') == 2 || session()->get('u_roll_id') == 3){
                   $uids[] =  session()->get('uid'); 
                   $data = $this->stockModel->getAllParentCatStockUserId($st_cat_id,$uids);
               }
        
        
        }

        
        return json_encode($data);

    
    }

    public function getPiStockRequest(){
       
       $uids = array();
       if (session()->get('u_roll_id') == 1) { 
           $pi_uid = session()->get('uid');
           $data = $this->groupModel->getPiGroupData($pi_uid);
        if(!empty($data)){
             $uids =  explode(',' ,$data[0]->uid);
        }else{
             $uids[] = $pi_uid; 
        }
           $data = $this->stockModel->getAllParentCatStockUserId(4,$uids);
    
       }elseif(session()->get('u_roll_id') == 2 || session()->get('u_roll_id') == 3){
           $uids[] =  session()->get('uid'); 
           $data = $this->stockModel->getAllParentCatStockUserId(4,$uids);
       }
        
        return json_encode($data);

    
    }

    public function getPiCart($pi_id){
        // $order = $this->orderModel->where('u_id',$pi_id)->first();
        $cart = [];
        // if(!$order){
            $cart = $this->cartModel->getPiCartDetails($pi_id);
        // }
        return json_encode($cart);
    }

    public function piPlaceOrder()
    {
        // $u_id    = $this->request->getPost('u_id');
        // $this->securityModel->sanitize_input($u_id);
        // $stock_ordered  = $this->request->getPost('stock_ordered');
        // $this->securityModel->sanitize_input($stock_ordered);
        // for($i = 0; $i < count($stock_ordered); $i++){
        //     $data['u_id']           = $u_id;
        //     $data['cart_id'] = $stock_ordered[$i];
        //     $data['order_status'] = 1;
        //     if($this->orderModel->save($data)){
        //         return true;
        //     } else {
        //         return false;
        //     }
        // }

        $data = $this->request->getPost();
        $data['order_status'] = 1;

        $orderModel = $this->orderModel->where('u_id',$data['u_id'])->where('cart_id',$data['cart_id'])->where('order_status',1)->first();
        if(empty($orderModel)){
             $this->securityModel->sanitize_form_array($data);
            if($this->orderModel->save($data)){
                $update['c_status'] = 2;
                $this->cartModel->update($data['cart_id'],$update);
                return json_encode('success');
            } else {
                return json_encode('error');
            }
        }else{
            return json_encode('duplicate');
        }
    }

    public function getStockDetails($sid){
        $data = $this->stockModel->getStockDetails($sid);
        return json_encode($data);
    }

    public function picart(){
        return view('pi-cart');
    }

    public function myCart(){
        return view('my-cart');
    }

    public function piSaveCart(){
        $data = $this->request->getPost();
        $data['c_status'] = 1;

        $cartModel = $this->cartModel->where('u_id',$data['u_id'])->where('s_id',$data['s_id'])->where('c_status',1)->first();
        if(empty($cartModel)){
             $this->securityModel->sanitize_form_array($data);
            if($this->cartModel->save($data)){
                return json_encode('success');
            } else {
                return json_encode('error');
            }
        }else{
            return json_encode('duplicate');
        }

        
    }

    public function bulkView()
    {
        $s_id = $this->request->getPost('s_id');
        $data = $this->stockModel->getbulkall($s_id);
        return json_encode($data);
    }

    public function bulkDelete()
    {
        $s_id = $this->request->getPost('s_id');
        $this->securityModel->sanitize_form_array($s_id);
        if($this->stockModel->delete($s_id)){
            return true;
        } else {
            return false;
        }  
    }

    public function bulkDownload()
    {
        helper('download');
        $s_id = $this->request->getPost('s_id');
        $s_id_array = json_decode($s_id, true); 
        if (!is_array($s_id_array)) {
            throw new InvalidArgumentException('Invalid IDs provided');
        }
        $data = $this->stockModel->getBulkAll($s_id_array); 
        $csvcontent = "STOCK ID,STOCK CATEGORY,PI,NCBS ID,TITLE,BARCODE,OLD NCBS ID,GENOTYPE,CG NUMBER,PHENOTYPE,GENERATED BY,VISIBLE MARKERS,OBTAINED BY,CHOROMOSOME AFFECTED,PUBLICATIONS,FLY BASE LINK,PRICE,FLY CONDITION,AVAILABILITY,SORT ORDER,COMMENT,GENE AFFECTED,PI EMAIL,GROUP NAME\n";
        foreach ($data as $row) {
            $row1 = (array) $row;
            $csvcontent .= implode(",", $row1) . "\n";
        }
        $filename = 'data.csv';
        $this->response->setHeader('Content-Type', 'text/csv');
        $this->response->setHeader('Content-Disposition', 'attachment; filename="' . $filename . '"');
        $this->response->setBody($csvcontent);
        return $this->response;
    }

    public function bulkEdit()
    {
        return view('bulk-edit');
    }

    public function bulkEditSubmit()
    {
        $file = $this->request->getFile('upload');

        if ($file->isValid() && !$file->hasMoved()) {

            $file->move(WRITEPATH . 'uploads/');
            
            $filePath = WRITEPATH . 'uploads/' . $file->getName();
            

            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($filePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray();
            
            if($this->stockModel->updateExcel($sheetData)){
                return true;
            } else{
                return false;
            }     
        }
    }

    public function moveStock()
    {
        $data['category'] = $this->stockCategoryModel->findAll();
        $data['stock'] = $this->stockModel->findAll();
        return view('move-stock',$data);
    }

    public function getStockByCategory()
    {
        $st_cat_id = $this->request->getPost('st_cat_id');
        $data = $this->stockModel->select('s_id,title')->where('st_cat_id',$st_cat_id)->findAll();
        echo json_encode($data);
    }

    public function assignStock()
    {
        $st_cat_id_old = $this->request->getPost('st_cat_id_old');
        $this->securityModel->sanitize_input($st_cat_id_old);
        $st_cat_id_new = $this->request->getPost('st_cat_id_new');
        $this->securityModel->sanitize_input($st_cat_id_new);
        if($st_cat_id_new != ''){
            $data['st_cat_id'] = $st_cat_id_new;
        } else {
            $data['st_cat_id'] = $st_cat_id_old;
        }
        $s_ids = $this->request->getPost('s_id');
        $this->securityModel->sanitize_input($s_ids);
        for($i = 0; $i < count($s_ids); $i++){
            $s_id = $s_ids[$i];
            $this->stockModel->update($s_id,$data);
        }
        return true;
    }

    public function assignTo()
    {
        $data['stock'] = $this->stockModel->findAll();
        $data['user'] = $this->userModel->where('u_roll_id','1')->findAll();
        return view('assign-stock',$data);
    }

    public function assignToLA()
    {
        $uid = $this->request->getPost('uid');
        $s_ids = $this->request->getPost('s_id');
        $this->securityModel->sanitize_input($uid);
        $this->securityModel->sanitize_form_array($s_ids);
        for($i = 0; $i < count($s_ids); $i++){
            $data['st_stock_id'] = $s_ids[$i];
            $data['st_current_handler'] = $uid;
            $this->stockTransferModel->save($data);
        }
        return true;
    }

    public function assignStockAdmin()
    {

        $data = $this->request->getPost();
        $admin['stock_handled_by'] = $data['aid'];
        $s_ids = $data['s_id'];
        $this->securityModel->sanitize_form_array($s_ids);
        for($i = 0; $i < count($s_ids); $i++){
            $s_id = $s_ids[$i];
            $this->stockModel->update($s_id,$admin);
        }
        return true;
    }

    public function stockCount()
    {
        return view('stock-count');
    }

    public function countChart()
    {
        $data['tcount'] = count($this->stockModel->findAll());
      
        $data['commonCatwise'] = $this->stockModel->stockByCommonCategory();
        $data['commonFlyWise'] = $this->stockModel->stockByCommonFlyWise();
        $data['piCollectionPiWise'] = $this->stockModel->getPiCollectionPiWise();
        $data['piCollectionFlyWise'] = $this->stockModel->stockByPiCollectionFlyWise();
        echo json_encode($data);
    }

  

   

public function code128($code)
{
    if (empty($code)) {
        throw new \CodeIgniter\Exceptions\PageNotFoundException('Barcode not provided');
    }

    $generator = new BarcodeGeneratorPNG();
    $barcode = $generator->getBarcode($code, $generator::TYPE_CODE_128);

    return $this->response
        ->setHeader('Content-Type', 'image/png')
        ->setBody($barcode);
}

public function barcodeRangeg()
{
    $start = $this->request->getPost('start_id'); // e.g. VI.1A-15
    $end   = $this->request->getPost('end_id');   // e.g. VI.1A-30

    if (!$start || !$end) {
        return redirect()->back()->with('error', 'Both Start and End IDs are required.');
    }

    // Extract prefix and numeric part
    $startParts = explode('-', $start);
    $endParts   = explode('-', $end);

    if (count($startParts) != 2 || count($endParts) != 2) {
        return redirect()->back()->with('error', 'Invalid ID format. Example: VI.1A-15');
    }

    $prefixStart = $startParts[0];
    $prefixEnd   = $endParts[0];

    if ($prefixStart !== $prefixEnd) {
        return redirect()->back()->with('error', 'Start ID and End ID must have the same prefix (e.g. VI.1A).');
    }

    $numStart = (int) $startParts[1];
    $numEnd   = (int) $endParts[1];

    if ($numStart > $numEnd) {
        return redirect()->back()->with('error', 'Start ID cannot be greater than End ID.');
    }

    $builder = $this->db->table('stock');
    $builder->like("old_ncbs_id", $prefixStart."%", "after");
    $builder->where("CAST(SUBSTRING_INDEX(old_ncbs_id, '-', -1) AS UNSIGNED) >=", $numStart);
    $builder->where("CAST(SUBSTRING_INDEX(old_ncbs_id, '-', -1) AS UNSIGNED) <=", $numEnd);
    $builder->orderBy("CAST(SUBSTRING_INDEX(old_ncbs_id, '-', -1) AS UNSIGNED)", "ASC");
    $stocks = $builder->get()->getResultArray();

    if (empty($stocks)) {
        return redirect()->back()->with('error','No stocks found in this range.');
    }

    return view('stock/barcode-sheet', ['stocks' => $stocks]);
}


public function barcodeRange()
{

    $start_id = $this->request->getPost('start_id'); // e.g. VI.1A-15
    $end_id   = $this->request->getPost('end_id');   // e.g. VI.1A-30


    $stocks = $this->stockModel->getStockByIdRange($start_id,$end_id);

    

    if(empty($stocks)){
        return redirect()->back()->with('error','No stocks found in this range.');
    }


    return view('barcode-sheet', ['stocks' => $stocks]);
}










}
