<?php

namespace App\Controllers;

use App\Models\StockCategory_Model;
use App\Models\OrderStatus_Model;
use App\Models\Flycondition_Model;
use App\Models\Security_Model;

class StockCategory extends BaseController
{
    protected $stockCategoryModel;
    protected $orderStatusModel;
    protected $flyConditionModel;
    protected $securityModel;

    public function __construct()
    {
        $this->stockCategoryModel = new StockCategory_Model();
        $this->orderStatusModel = new OrderStatus_Model();
        $this->flyConditionModel = new Flycondition_Model();
        $this->securityModel = new Security_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
		$data = array();
        $data['orderstatus'] = $this->orderStatusModel->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        return view('stock-category',$data);
    }

    public function getById($scat_id)
    {
        $data = $this->stockCategoryModel->where('scat_id', $scat_id)->first();
        return json_encode($data);
    }

    public function getAll()
    {
        $data = $this->stockCategoryModel->getStockCategory();
        return json_encode($data);
    }

    public function save()
    {
        $data = $this->request->getPost();
        $this->securityModel->sanitize_form_array($data);
        if($this->stockCategoryModel->save($data)){
            return true;
        } else {
            return false;
        }
    }

    public function update()
    {
        $scat_id = $this->request->getPost('scat_id');
        $data = array();
        $data['scat_name']           = $this->request->getPost('scat_name1');
        // $data['scat_centers']        = $this->request->getPost('scat_centers1');
        // $data['scat_fly_conditions'] = $this->request->getPost('scat_fly_conditions1');
        // $data['scat_ord_status']     = $this->request->getPost('scat_ord_status1');
        $this->securityModel->sanitize_form_array($data);
        if($this->stockCategoryModel->update($scat_id,$data)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $scat_id = $this->request->getPost('scat_id');
        $this->securityModel->sanitize_input($scat_id);
        if($this->stockCategoryModel->delete($scat_id)){
            return true;
        } else {
            return false;
        }  
    }
}
